<?php

namespace App\Services;

use Monolog\Logger;
use Monolog\Handler\StreamHandler;

class LogManager {
    private $loggers = [];
    private $loggingEnabled = true; // Set this to false to disable logging

    public function getLogger($functionName, $supplier) {
        if (!$this->loggingEnabled) {
            return null; // Skip logger creation when logging is disabled
        }

        $key = "{$supplier}-{$functionName}";
        if (!isset($this->loggers[$key])) {
            $logger = new Logger($key);
            $date = date('Y-m-d');
            $logDirectory = __DIR__ . "/../../logs/{$supplier}/";
            if (!file_exists($logDirectory)) {
                mkdir($logDirectory, 0777, true);
            }
            $logger->pushHandler(new StreamHandler("{$logDirectory}{$functionName}.log", Logger::INFO));
            $this->loggers[$key] = $logger;
        }
        return $this->loggers[$key];
    }

    public function logError($message, $functionName, $supplier) {
        if ($this->loggingEnabled) {
            $logger = $this->getLogger($functionName, $supplier);
            if ($logger) {
                $logger->error($message);
            }
        }
    }

    public function logInfo($message, $functionName, $supplier) {
        if ($this->loggingEnabled) {
            $logger = $this->getLogger($functionName, $supplier);
            if ($logger) {
                $logger->info($message);
            }
        }
    }
}
