<?php

namespace App\Services;

use App\Services\LogManager;

class DownloadService {
    private $logManager;
    private $downloadDir;

    public function __construct() {
        $this->logManager = new LogManager();
        $this->downloadDir = __DIR__ . '/../../data/supplier1/';
        
        // Ensure the download directory exists
        if (!is_dir($this->downloadDir)) {
            mkdir($this->downloadDir, 0777, true);
            $this->logManager->logInfo("Created download directory: " . $this->downloadDir, 'download', 'supplier1');
        }
    }

    public function downloadXml() {
        $url = $_ENV['SUPPLIER_ONE_URL'];
        if (!$url) {
            $this->logManager->logError("SUPPLIER_ONE_URL environment variable is not set", 'download', 'supplier1');
            throw new \Exception("SUPPLIER_ONE_URL environment variable is not set");
        }

        $xmlContent = $this->downloadXmlUsingCurl($url);
        if ($xmlContent === false) {
            $this->logManager->logError("Failed to retrieve the XML file from {$url}", 'download', 'supplier1');
            throw new \Exception("Failed to retrieve the XML file from {$url}");
        }

        $filePath = $this->downloadDir . 'supplier_one.xml';
        file_put_contents($filePath, $xmlContent);
        $this->logManager->logInfo("Downloaded XML file to: " . $filePath, 'download', 'supplier1');
    }

    private function downloadXmlUsingCurl($url) {
        $ch = curl_init();
    
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            
        $output = curl_exec($ch);
    
        if (curl_errno($ch)) {
            $error = 'Curl error: ' . curl_error($ch);
            $this->logManager->logError($error, 'download', 'supplier1');
            curl_close($ch);
            return false;
        }
    
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($httpCode != 200) {
            $error = "HTTP request failed with code {$httpCode}";
            $this->logManager->logError($error, 'download', 'supplier1');
            curl_close($ch);
            return false;
        }
    
        $this->logManager->logInfo("HTTP request successful with code {$httpCode}", 'download', 'supplier1');
    
        curl_close($ch);
        return $output;
    }
    
}
