<?php

namespace App\Controllers;

use App\Services\SupplierOneService;
use App\Services\CategoryService;
use App\Services\ProductService;

class SupplierOneController {
    private $service;
    private $categoryService;
    private $productService;

    public function __construct() {
        $this->service = new SupplierOneService();
        $this->categoryService = new CategoryService();
        $this->productService = new ProductService();
    }

    public function handleImport() {
        try {
            // Importing Data and Filtering them
            echo "Starting import for Supplier One...\n";
            $this->service->importData();
            echo "Import completed. Now processing categories...\n";
            // Adding and removing Categories
            
        } catch (\Exception $e) {
            echo "Failed to import data: " . $e->getMessage() . "\n";
        }
    }

    // New method to handle the form submission and category assignment
    public function processCategoryForm($formData) {
        try {
            echo "Processing category assignments...\n";
            $this->service->processFormData($formData);
            echo "Category assignments completed successfully.\n";

            // Now that the form data is processed, initiate the category sync via the API
            echo "Syncing categories with the API...\n";
            $this->categoryService->processCategories();
            echo "Category syncing completed successfully.\n";

            // Now that the category is processed, initiate the product sync via the API
            echo "Syncing products with the API...\n";
            //$this->productService->processProducts();
            echo "Products completed successfully.\n";

            // Now that the category is processed, initiate the product sync via the API
            echo "Deleting products that are not in XML...\n";
            //$this->productService->deleteObsoleteProducts();
            echo "Deleting products completed successfully.\n";
        } catch (\Exception $e) {
            echo "Failed to process category assignments: " . $e->getMessage() . "\n";
        }
    }
}
